﻿<?php




 <script>
funtion editor('editor')
{
  const editorElement = document.getElementById('editor');
  const languageElement = document.getElementById('language');
  const undoElement = document.getElementById('undo');
  const redoElement = document.getElementById('redo');
  const clearStorage = document.getElementById('clearStorage');

  clearStorage.addEventListener('click', () => {
    localStorage.removeItem('editorTextContent');
  });

  editorElement.addEventListener('changed', (event) => {
    undoElement.disabled = !event.detail.canUndo;
    redoElement.disabled = !event.detail.canRedo;
  });

  editorElement.addEventListener('exported', (event) => {
    localStorage.setItem('editorTextContent', event.detail.exports['text/plain']);
  });

  editorElement.addEventListener('loaded', async (evt) => {
    /**
     * Retrieve the list of available recognition languages
     * @param {Object} The editor recognition parameters
     */
    const currentLanguage = evt.target.editor.configuration.recognitionParams.iink.lang;
    const res = await iink.getAvailableLanguageList(evt.target.editor.configuration);

    if (languageElement.options.length === 0) {
      Object.keys(res.result).forEach((key) => {
        const selected = currentLanguage === key;
        languageElement.options[languageElement.options.length] = new Option(res.result[key], key, selected, selected);
      });
    }
  });

  languageElement.addEventListener('change', (e) => {
    const configuration = editorElement.editor.configuration;
    //The path to the language depend of the version of API you are using.
    configuration.recognitionParams.iink.lang = e.target.value;
  });

  undoElement.addEventListener('click', () => {
    editorElement.editor.undo();
  });
  redoElement.addEventListener('click', () => {
    editorElement.editor.redo();
  });

  /**
   * Attach an editor to the document
   * @param {Element} The DOM element to attach the ink paper
   * @param {Object} The recognition parameters
   */
  iink.register(editorElement, {
    recognitionParams: {
      type: 'TEXT',
      protocol: 'WEBSOCKET',
      server: {
        scheme: 'https',
        host: 'webdemoapi.myscript.com',
        applicationKey: 'a9e38ab5-5850-4856-8308-dc2b724b10b8',
        hmacKey: 'e61dda07-0fb1-4f89-af1e-c07f67835ab1'
      }
    }
  });

  let editorTextContent;
  if (localStorage.editorTextContent) {
    editorTextContent = localStorage.getItem('editorTextContent');
    editorElement.editor.import_(editorTextContent, 'text/plain');
  }

  window.addEventListener('resize', () => {
    editorElement.editor.resize();
  });

}
</script>

}


?>